-- BRDM-2L1 ARV by Currenthill

-- Chassis
GT_t.CH_t.BRDM2L1 = {
	life = 2,
	mass = 7000,
	length = 5.75,
	width = 2.35,
	max_road_velocity = 27.78,
	max_slope = 0.4,
	canSwim = true,
	waterline_level = 1.4,	
	fordingDepth = 1.2,
	engine_power = 145,	
	engineMinRPM = 700,
	engineMaxPowerRPM = 3600,
	engineMaxRPM = 5000,
	gearRatios = {-5.25, 0.0, 5.25, 2.842, 1.912, 1.284, 0.858},
	mainGearRatio = 5.5,	
	automaticTransmission = true,		
	max_vert_obstacle = 0.4,
	max_acceleration = 0.95,
	min_turn_radius = 6.5,
	X_gear_1 = 1.24,
	Y_gear_1 = 0,
	Z_gear_1 = 0.95,
	X_gear_2 = -1.73,
	Y_gear_2 = 0,
	Z_gear_2 = -0.95,
	gear_type = GT_t.GEAR_TYPES.WHEELS,
	r_max = 0.60,
	armour_thickness = 0.002,	
}

GT = {};
GT_t.ws = 0;
set_recursive_metatable(GT, GT_t.generic_wheel_vehicle);
set_recursive_metatable(GT.chassis, GT_t.CH_t.BRDM2L1);

GT.visual.shape = "BRDM-2L1";
GT.visual.shape_dstr = "BRDM-2L1-dest";
GT.toggle_alarm_state_interval = 3.0;

GT.swing_on_run = false;
GT.IR_emission_coeff = 0.1

GT.sensor = {};
set_recursive_metatable(GT.sensor, GT_t.SN_visual);
GT.sensor.height = 3.3;

-- Burning after hit
GT.visual.fire_size = 0.5; --relative burning size
GT.visual.fire_pos[1] = -0.35; -- center of burn at long axis shift(meters)
GT.visual.fire_pos[2] = 1.5; -- center of burn shift at vertical shift(meters)
GT.visual.fire_pos[3] = 0; -- center of burn at transverse axis shift(meters)
GT.visual.fire_time = 60; --burning time (seconds)
GT.visual.dust_pos = {0.95, 0.06, 0}
GT.visual.dirt_pos = {-0.95, 0.08, 0}


GT.driverViewConnectorName = {"POINT_DRIVER_01", offset = {0.0, 0.0, 0.0}}
GT.driverCockpit = "DriverCockpit/DriverCockpitWithLLTV"

-- weapon systems
GT.WS = {};
GT.WS.maxTargetDetectionRange = 5000;
GT.WS.fire_on_march = true;

-- ================================ KVPT 14.5 mm machine gun =======================================

ws = GT_t.inc_ws();
GT.WS[ws] = {}
GT.WS[ws].center = 'CENTER_TOWER_01' 
GT.WS[ws].pointer = "POINT_SIGHT_01"; 
GT.WS[ws].cockpit =  {"_1PZ-2/_1PZ-2", {0.0, 0.0, 0.0 }}
GT.WS[ws].drawArgument1 = 0
GT.WS[ws].drawArgument2 = 1 
GT.WS[ws].omegaY = math.rad(25);
GT.WS[ws].omegaZ = math.rad(10); 
GT.WS[ws].stabilizer = false;
GT.WS[ws].laser = false;
GT.WS[ws].angles = {
                    {math.rad(180), math.rad(-180), math.rad(-5), math.rad(30)},
                    };
GT.WS[ws].reference_angle_Y = math.rad(0);	
GT.WS[ws].reference_angle_Z = math.rad(10);	
				

--GT.WS[1].LN[1]
__LN = add_launcher(GT.WS[ws], GT_t.LN_t.BRDM2L1_KPVT);
__LN.BR[1] = { connector_name = 'POINT_GUN_01', 
							recoilArgument = 2,
							recoilTime = 60/450/2 }
__LN.sightMasterMode = 1;
__LN.sightIndicationMode = 1;	


-- =============================== KT 7.62 mm Coax machine gun =====================================

--GT.WS[1].LN[2]
__LN = add_launcher(GT.WS[ws], GT_t.LN_t.BRDM2L1_KT);
__LN.secondary = true;
__LN.BR[1] = { connector_name = 'POINT_GUN_02', 
							recoilArgument = 50,
							recoilTime = 60/650/2 }			
				
-- =================================================================================================

GT.Name = "CH_BRDM2L1";
GT.DisplayName = _('[CH] BRDM-2L1 ARV');
GT.DisplayNameShort = _('BRDM-2L1');
GT.Rate = 8;

GT.Sensors = { 
	Mount_WS_ID = 1,
	OPTIC = {"TKN-3B day", "TKN-3B night",
                        },
	noVisualDetectorInAlarmedState = false							
            };

GT.EPLRS = true

GT.InternalCargo = {
    nominalCapacity = 400,
    maximalCapacity = 400,
}

GT.DetectionRange  = 0;
GT.airWeaponDist = 2000
GT.ThreatRange = 2000;
GT.mapclasskey = "P0091000004";
GT.attribute = {wsType_Ground, wsType_Tank, wsType_Gun, WSTYPE_PLACEHOLDER,
                "APC",
                };
GT.category = "Armor"

GT.tags  =
{
    "Armor",
	"Scout/Recon",
}

GT.Countries = {"Ukraine","Russia"}
